Ext.data.JsonP.sol_common_forms_FormWrapper({"tagname":"class","name":"sol.common.forms.FormWrapper","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.forms.FormWrapper.js","href":"lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper"}],"abstract":true,"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"elowf":true,"requires":["sol.common.DateUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"activeState","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-activeState","meta":{}},{"name":"addBodyClass","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-addBodyClass","meta":{"private":true}},{"name":"fields","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-fields","meta":{}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"onInitAndTabChangeFunctions","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-onInitAndTabChangeFunctions","meta":{}},{"name":"onSaveRules","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-onSaveRules","meta":{}},{"name":"removeBodyClass","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-removeBodyClass","meta":{"private":true}},{"name":"tabs","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-tabs","meta":{}},{"name":"wfName","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-wfName","meta":{}},{"name":"wfVersion","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-wfVersion","meta":{}},{"name":"workflowActive","tagname":"property","owner":"sol.common.forms.FormWrapper","id":"property-workflowActive","meta":{}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"InputChanged","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-InputChanged","meta":{"private":true}},{"name":"OnInitAndTabChange","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-OnInitAndTabChange","meta":{"private":true}},{"name":"OnLineChange","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-OnLineChange","meta":{"private":true}},{"name":"OnSave","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-OnSave","meta":{"private":true}},{"name":"TabChanged","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-TabChanged","meta":{"private":true}},{"name":"addTemplateStatesToStates","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-addTemplateStatesToStates","meta":{"private":true}},{"name":"applyTemplate","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-applyTemplate","meta":{"private":true}},{"name":"assignPropToFields","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-assignPropToFields","meta":{}},{"name":"assignResponders","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-assignResponders","meta":{"private":true}},{"name":"assignValidationFunctionsToWindow","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-assignValidationFunctionsToWindow","meta":{"private":true}},{"name":"assignValidators","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-assignValidators","meta":{"private":true}},{"name":"batchProcessProperties","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-batchProcessProperties","meta":{"private":true}},{"name":"calculateDate","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-calculateDate","meta":{}},{"name":"determineUndefinedFields","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-determineUndefinedFields","meta":{"private":true}},{"name":"endsWith","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-endsWith","meta":{}},{"name":"executeOnSaveRules","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-executeOnSaveRules","meta":{"private":true}},{"name":"getActiveTabId","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-getActiveTabId","meta":{}},{"name":"getElementsOfAllTabsOnForm","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-getElementsOfAllTabsOnForm","meta":{"private":true}},{"name":"getNameOfKwlSource","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-getNameOfKwlSource","meta":{"private":true}},{"name":"getNamesOfAllFieldsOnForm","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-getNamesOfAllFieldsOnForm","meta":{"private":true}},{"name":"getNewFieldsOnForm","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-getNewFieldsOnForm","meta":{"private":true}},{"name":"getPartsOfTab","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-getPartsOfTab","meta":{"private":true}},{"name":"getShortName","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-getShortName","meta":{}},{"name":"hidePartsContainingOnlyEmptyFields","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-hidePartsContainingOnlyEmptyFields","meta":{}},{"name":"hideUnnecessaryParts","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-hideUnnecessaryParts","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-initialize","meta":{}},{"name":"initializeFields","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-initializeFields","meta":{"private":true}},{"name":"initializeNewField","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-initializeNewField","meta":{"private":true}},{"name":"initializeNewFields","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-initializeNewFields","meta":{}},{"name":"initializeRowFieldsOfMapTableKwl","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-initializeRowFieldsOfMapTableKwl","meta":{"private":true}},{"name":"initializeTabs","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-initializeTabs","meta":{"private":true}},{"name":"logFieldValues","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-logFieldValues","meta":{}},{"name":"processAFieldsProperties","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-processAFieldsProperties","meta":{"private":true}},{"name":"processAPartsProperties","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-processAPartsProperties","meta":{"private":true}},{"name":"propIsField","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-propIsField","meta":{}},{"name":"reassignEloVerify","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-reassignEloVerify","meta":{"private":true}},{"name":"reassignLocalizedKwlValues","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-reassignLocalizedKwlValues","meta":{}},{"name":"removeBodyClasses","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-removeBodyClasses","meta":{"private":true}},{"name":"removeFromUndefinedFields","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-removeFromUndefinedFields","meta":{"private":true}},{"name":"removeOldBodyClasses","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-removeOldBodyClasses","meta":{}},{"name":"returnCalculatedDate","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-returnCalculatedDate","meta":{}},{"name":"setBodyClasses","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-setBodyClasses","meta":{"private":true}},{"name":"setCalculatedDate","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-setCalculatedDate","meta":{}},{"name":"setFieldProperties","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-setFieldProperties","meta":{"private":true}},{"name":"setNewBodyClasses","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-setNewBodyClasses","meta":{"private":true}},{"name":"setState","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-setState","meta":{}},{"name":"setTabProperties","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-setTabProperties","meta":{"private":true}},{"name":"shouldISave","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-shouldISave","meta":{"private":true}},{"name":"today","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-today","meta":{}},{"name":"wfMeetsVersionRequirement","tagname":"method","owner":"sol.common.forms.FormWrapper","id":"method-wfMeetsVersionRequirement","meta":{}}],"code_type":"ext_define","id":"class-sol.common.forms.FormWrapper","short_doc":"Provides extensive utilities for working with ELO-forms. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.forms.FormWrapper</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper' target='_blank'>lib_sol.common.forms.FormWrapper.js</a></div></pre><div class='doc-contents'><p>Provides extensive utilities for working with ELO-forms.</p>\n\n<p>Using FormWrapper's simple state-manager, you can define\napplication states consisting of fields and their respective:</p>\n\n<ul>\n<li>values</li>\n<li>labels</li>\n<li>tooltips</li>\n<li>attributes (readonly / hidden / optional)</li>\n<li>responders:\na responder is a function which will get called when the field's value is changed</li>\n<li>validators:\na validator is a function which will get called when a field is clicked. Afterwards\nthe validation massage is shown in the client.</li>\n</ul>\n\n\n<p> There is also support for behaviour templates which provide common behaviours to a group of fields.\n You can use templates defined in FormWrapper.Templates (end of this file)</p>\n\n<h1>Setup</h1>\n\n<p> The Wrapper must be initialized in a form's <code>Header.txt</code>.\n e.g.:</p>\n\n<pre><code>&lt;script type=\"text/javascript\" src=\"lib_sol.common.forms.FormWrapper\"&gt;&lt;/script&gt;\n&lt;script type=\"text/javascript\" src=\"lib_sol.hr.forms.PersonnelFile\"&gt;&lt;/script&gt;\n</code></pre>\n\n<p> <code>lib_sol.hr.forms.PersonnelFile</code> will be a separate class extending\n the form-wrapper by the customer specific logic. Therefore, also add these entries to your <code>Header.txt</code>:</p>\n\n<pre><code>// ELO &lt; 10.1 does not support onInit here. Just add these lines to inputChanged source == null instead.\nfunction onInit() {\n  this.form = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.hr.forms.PersonnelFile\");\n  this.form.OnInitAndTabChange();\n}\n\nfunction tabChanged(id) {\n  this.form.TabChanged(id);\n}\n\nfunction inputChanged(source) {\n  source == null ?\n    window.setTimeout(function() { <a href=\"#!/api/sol.common.forms.Utils-method-initializeForm\" rel=\"sol.common.forms.Utils-method-initializeForm\" class=\"docClass\">sol.common.forms.Utils.initializeForm</a>(); }, 100)\n    : this.form.InputChanged(source);\n}\n\nfunction nextClicked(id) {\n  return (\n    <a href=\"#!/api/sol.common.forms.Utils-method-disableCancelButtonValidation\" rel=\"sol.common.forms.Utils-method-disableCancelButtonValidation\" class=\"docClass\">sol.common.forms.Utils.disableCancelButtonValidation</a>(id, [\"sol.common.wf.node.cancel\"])\n    || this.form.OnSave()\n  );\n}\n\nfunction saveClicked() {\n  return this.form.OnSave();\n}\n\nfunction addLineClicked(addLineId, groupIndex) {\n  this.form.OnLineChange(true, addLineId, groupIndex);\n}\n\nfunction removeLineClicked(addLineId, groupIndex) {\n  return this.form.OnLineChange(true, addLineId, groupIndex);\n}\n\nfunction onDynListItemSelected(item, inputName) {\n  this.form.InputChanged(item, inputName);\n}\n</code></pre>\n\n<p> By defining all customer specific logic in the extending class, your <code>Header.txt</code> will be much cleaner.\n It is recommended not to call any additional customer specific util-functions in <code>Header.txt</code>. Instead, you\n should <code>include</code> your customer-specific logic solely in the extending class.</p>\n\n<p> You can define and use multiple extending classes in one Header.txt.</p>\n\n<p> Minimal example for an extending class <code>PersonnelFile</code>:</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.hr.forms.PersonnelFile\", {\n  extend: \"<a href=\"#!/api/sol.common.forms.FormWrapper\" rel=\"sol.common.forms.FormWrapper\" class=\"docClass\">sol.common.forms.FormWrapper</a>\",\n  prefix: \"HR_PERSONNEL\"  // usually all customer-specific fields have some kind of prefix. You can define it here.\n}\n</code></pre>\n\n<h1>Usage</h1>\n\n<p> The wrapper functions are now available in the form. These are some common use-cases:</p>\n\n<h3>Field functions (this.form.fields.FIELDNAME)</h3>\n\n<p>Every field on the form (MAP,GRP) is represented as an object.\n   .value(opts)-   returns the field's value.\n                   (isodate for date-fields and the key for localized Kwls).\n                   pass <code>{full: true}</code> to receive the localized value of an lKwl instead of key only\n                   pass <code>{asNumber: true}</code> to receive the value as a number. (e.g. valuable for localized number strings)</p>\n\n<p>   .set(val)   -   replaces the field's value by <code>val</code>\n                   (for val, pass an isodate date-fields and for localizedKwls pass the key)</p>\n\n<p>   .element()  -   returns the field's HTML element</p>\n\n<p>   .show()     -   displays the field in the form\n                   (will also show the field's label and selector if called with .(true, true))</p>\n\n<p>   .hide()     -   hides the field\n                   (will also hide the field's label and selector if called with .(true, true))</p>\n\n<p>   .setAttribute(\"readonly\", true)\n               -   renders a field readonly (pass false to make it writeable again)</p>\n\n<p>   .setAttribute(\"optional\", true)\n               -   makes a field optional. Pass false to make a field required</p>\n\n<p>   .tooltip()\n               -   if a tooltip is defined, returns the tooltip as a String</p>\n\n<p>   .writeTooltip(tooltip)\n               -   Adds a tooltip to the field\n               -   removes tooltip if falsy value is passed</p>\n\n<p>   .setImage(guid)   -   only works on image-fields! Downloads an image specified by guid and sets the image-fields src-attribute\n                        if no guid is passed, but the sord contains a guid as the fields value, it will be used as a fallback</p>\n\n<p> show and hide of labels will only work, if you assign the label's \"variable\" field a value of \"LBL_\" + <code>Fieldname without IX_MAP/GRP</code>\n and the label's respective input-field's variable field contains the prefix defined in the extending class definition (e.g. HR_PERSONNEL)</p>\n\n<h3>Form functions (this.form)</h3>\n\n<p>   .setState(statename)\n               -   transforms the form according to the state-definition</p>\n\n<p>   .activeState\n               -   stores the currently active state</p>\n\n<p>   .getActiveTabId()\n               -   returns the id of the currently active tab (e.g. \"_501_time_phases\")</p>\n\n<p>   .today()    -   returns the current client date as an isodate</p>\n\n<p>   .logFieldValues(b) -   logs all fieldnames and their values to the console (as a table if implemented). pass true as parameter to return fields and values as an array instead of a console-log</p>\n\n<h3>Tabs functions (this.form.tabs)</h3>\n\n<p>   ._tabName  -   returns the tab object of the tab \"tabName\"</p>\n\n<p>   .activeTab  -   returns the tab object of the active tab</p>\n\n<p>   .all  - holds an object containing all templates which are available on the form</p>\n\n<h3>Tab functions (this.form.tabs._tabName)</h3>\n\n<p>   .parts      -   holds an object containing the tab's templates (called \"parts\" in this framework)</p>\n\n<p>   .parts._partName - holds the part-object having the name \"partName\"</p>\n\n<p>   .containsCover  - boolean. does the tab contain a business solution coversheet? (__cover)</p>\n\n<p>   .hidePartsContainingOnlyEmptyFields() - hides all parts of a tab which where none of each part's fields has a value.</p>\n\n<p>   .hideUnnecessaryParts(array) - hides all parts which do not contain any of the fields listed in the passed array</p>\n\n<h3>Template/Part functions (this.form.tabs_tabName.parts._partName)</h3>\n\n<p>   .show()     -   shows the template/part</p>\n\n<p>   .hide()     -   hides the template/part</p>\n\n<p>   .isCover    -   is the part a business solution coversheet? (__cover)</p>\n\n<h1>States:</h1>\n\n<p> The class extending <a href=\"#!/api/sol.common.forms.FormWrapper\" rel=\"sol.common.forms.FormWrapper\" class=\"docClass\">sol.common.forms.FormWrapper</a> can define multiple states, which can be\n set e.g. on input-changed events (responders). Usually, states are changed in \"responder\"-functions or\n the \"BeforeOnInitAndTabChange\" function, which will be called once during initialization\n of the wrapper and again on every tab-change. \"AfterOnInitAndTabChange\" is called\n after all states' \"OnInitAndTabChange\"-functions were called. (see e.g. templates, which\n define their own OnInitAndTabChange function).\n There is also \"BeforeInputChanged\" and \"AfterInputChanged\", which will be called\n before/after the changed field's responder has been executed.</p>\n\n<h3>Order of computation</h3>\n\n<pre><code>(# means, you can define this function in the extending class)\ninitialize: called during <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>\n  #OnInit\nOnInitAndTabChange: called when initializing form and on a tab change\n  #BeforeOnInitAndTabChange\n  Calls all OnInitAndTabChange functions which are defined in templates or states. (#template.OnInitAndTabChange and #state.OnInitAndTabChange)\n  #AfterOnInitAndTabChange\nInputChanged: called when an input field´s value changes\n  #BeforeInputChanged\n  Calls the changed field´s #responder function\n  #AfterInputChanged\nOnSave: called when \"save\" is clicked\n  #BeforeOnSave\n  Calls all rules defined in <a href=\"#!/api/sol.common.forms.FormWrapper-property-onSaveRules\" rel=\"sol.common.forms.FormWrapper-property-onSaveRules\" class=\"docClass\">onSaveRules</a>\n  #AfterOnSave\n</code></pre>\n\n<h3>Exemplary Formwrapper extending class:</h3>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"sol.hr.forms.PersonnelFile\", {\n  extend: \"<a href=\"#!/api/sol.common.forms.FormWrapper\" rel=\"sol.common.forms.FormWrapper\" class=\"docClass\">sol.common.forms.FormWrapper</a>\",\n  prefix: \"HR_PERSONNEL\",   // IX_MAP_HR_PERSONNEL_DATEOFJOINING -&gt; Prefix = HR_PERSONNEL\n  defaultState: \"myDefaultState\",\n  //states begin\n  states: {\n    stateInit: {  //stateInit is called automatically when the form is initially loaded\n      //declare your desired initial state here (usually responders and validators)\n      fieldProperties: {\n        IX_MAP_DURATION_TYPE: {\n          responder: function(form, state, field, value) {\n            if (value == \"\") { form.setState(\"myDefaultState\")\n            } else { form.setState(\"durationTypeSelected\") };\n          }\n        }\n      }\n    },\n    myDefaultState: {\n      fieldProperties: {\n        IX_MAP_HR_PERSONNEL_DEPARTMENT: {\n          hidden: true\n        }\n      }\n    },\n    durationTypeSelected: {\n      fieldProperties: {\n        IX_MAP_HR_PERSONNEL_DEPARTMENT: {\n          value: \"Sales\"\n          hidden: false\n        }\n      }\n    },\n    departmentHasAValue: {\n      fieldProperties: { IX_MAP_HR_PERSONNEL_DEPARTMENT: { hidden: false } }\n    },\n  }\n}\n</code></pre>\n\n<h3>Explanation</h3>\n\n<p> First, during initialization, the stateInit state is set. Here, we assign a responder\n function to the field \"IX_MAP_DURATION_TYPE\", which will set the state \"durationTypeSelected\"\n as soon as the field has any value.</p>\n\n<p> The \"myDefaultState\" is set directly after \"stateInit\", because we defined it as me.defaultState\n In \"myDefaultState\", the field IX_MAP_HR_PERSONNEL_DEPARTMENT will be hidden.</p>\n\n<p> If someone enters a value into the \"IX_MAP_DURATION_TYPE\" field, its responder will be executed.\n The responder sets the state \"durationTypeSelected\", which sets the DEPARTMENT-field's value to\n \"Sales\" and unhides/shows the field in the form.</p>\n\n<p> Validators:\n You can define Validators in the fieldProperties of a field by assigning a \"validator:\" property.\n Tip: You don't have to define the validation function (\"JS_VAL_...\") in the form designer anymore!</p>\n\n<p> BodyClasses:\n You can define CSS-Bodyclasses in every state:\n myDefaultState: { bodyClasses: [\"greatDesign\", \"flexibleTable\"] }\n Attention: body classes will be removed, as soon as you execute \"setState\" for another state.\n To keep body-classes during state-change, you must define the property e.g.\n \"myDefaultState.removePreviousBodyClasses: false\" in subsequent states</p>\n\n<p> Template:\n To use a template, you have to define it instead of (or alongside) a field's properties.\n e.g.</p>\n\n<pre><code>...\nfieldProperties: {\n  IX_MAP_HR_PERSONNEL_CASSATIONTOGGLE: {\n    template: \"toggle\"\n    config: { ... } //see documentation at the end of this file for template configs.\n  }\n}\n...\n</code></pre>\n\n<p> Batchprocessing:\n It is tedious to define field:{hidden: true} if you want to hide many fields at once.\n You can use all field properties (hidden, readonly, optional, value, responder, ...) in batch\n processing. Example:</p>\n\n<pre><code>fieldProperties: {\n  _batch: {\n    hidden: {\n      val: true,\n      fields: [\n        \"IX_GRP_HR_PERSONNEL_DATEOFJOINING\", \"IX_MAP_HR_PERSONNEL_PROBATIONARYPERIODDURATION\"\n      ]\n    }\n  }\n}\n</code></pre>\n\n<p> Of course you can combine batch-processing and ´normal´ attribute setting.</p>\n\n<p> If you want to define your own templates, you can do so in the \"OnInit\" function.\n Just add your own templates to form.templates. E.g.:</p>\n\n<pre><code>form.templates.mygreattemplate = function (config) { ...  return configuredTemplate; };\n</code></pre>\n\n<h3>Conclusion</h3>\n\n<p> OnInitAndTabChange should be used to set up the environment for the user.\n (what happens if the user switches tabs,... )</p>\n\n<p> Any other state should be defined as ´state´.\n If you need more control than the standard field properties (value, hide,...) can offer,\n you can and should implement the logic directly in a field's responder instead of creating\n a state which won't have sufficient facilities to represent the desired state anyways.</p>\n\n<h1>Additional features</h1>\n\n<h3>Business Solution Coversheet</h3>\n\n<p> The Business Solution Coversheet provides an easy way to display information in a form as readonly-labels\n instead of input boxes.</p>\n\n<p> To display any MAP/GRP field in the coversheet, prepend \"VIEW_\" to its name when defining it in the coversheet\n template. e.g. IX_MAP_TEST -> VIEW_IX_MAP_TEST</p>\n\n<p> The template containing the coversheet must be named ending with \"__cover\" (two underscores)</p>\n\n<p> The required CSS rules will then be applied automatically.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-activeState' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-activeState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-activeState' class='name expandable'>activeState</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>holds the active state's name as a string</p>\n</div><div class='long'><p>holds the active state's name as a string</p>\n</div></div></div><div id='property-addBodyClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-addBodyClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-addBodyClass' class='name expandable'>addBodyClass</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-fields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-fields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-fields' class='name expandable'>fields</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>will contain all fields of the form after initializeFields has been called ...</div><div class='long'><p>will contain all fields of the form after initializeFields has been called</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-onInitAndTabChangeFunctions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-onInitAndTabChangeFunctions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-onInitAndTabChangeFunctions' class='name expandable'>onInitAndTabChangeFunctions</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>will contain all template OnInitAndTabChange functions after setState has been called ...</div><div class='long'><p>will contain all template OnInitAndTabChange functions after setState has been called</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-onSaveRules' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-onSaveRules' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-onSaveRules' class='name expandable'>onSaveRules</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>will contain rules, which are applied when a user presses the save button ...</div><div class='long'><p>will contain rules, which are applied when a user presses the save button</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-removeBodyClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-removeBodyClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-removeBodyClass' class='name expandable'>removeBodyClass</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-tabs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-tabs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-tabs' class='name expandable'>tabs</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>will contain all tabs of the form after initializeTabs has been called ...</div><div class='long'><p>will contain all tabs of the form after initializeTabs has been called</p>\n<p>Defaults to: <code>{all: {parts: {}}}</code></p></div></div></div><div id='property-wfName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-wfName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-wfName' class='name expandable'>wfName</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Name of ELO-wf (e.g. ...</div><div class='long'><p>Name of ELO-wf (e.g. wf-Solutions)</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='property-wfVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-wfVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-wfVersion' class='name expandable'>wfVersion</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Version of ELO-wf parsed to an Integer. ...</div><div class='long'><p>Version of ELO-wf parsed to an Integer. (10.04.032 = 1004032)</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-workflowActive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-property-workflowActive' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-property-workflowActive' class='name expandable'>workflowActive</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>true if the form is running in workflow mode. ...</div><div class='long'><p>true if the form is running in workflow mode. (set in initialize)</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-InputChanged' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-InputChanged' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-InputChanged' class='name expandable'>InputChanged</a>( <span class='pre'>source, name</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Basically executes the responder of a field which was changed by user input. ...</div><div class='long'><p>Basically executes the responder of a field which was changed by user input.\nIt is also possible to define a BeforeInputChanged and a AfterInputChanged\nfunction in the extending class to make changes before/after any field-change\nwithout specifically depending on one field.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-OnInitAndTabChange' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-OnInitAndTabChange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-OnInitAndTabChange' class='name expandable'>OnInitAndTabChange</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Executes registered callbacks when the tab is changed or the form is initialized. ...</div><div class='long'><p>Executes registered callbacks when the tab is changed or the form is initialized.</p>\n</div></div></div><div id='method-OnLineChange' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-OnLineChange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-OnLineChange' class='name expandable'>OnLineChange</a>( <span class='pre'>lineAdded, name, index</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>lineAdded</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>index</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-OnSave' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-OnSave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-OnSave' class='name expandable'>OnSave</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>OnSave callback ...</div><div class='long'><p>OnSave callback</p>\n</div></div></div><div id='method-TabChanged' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-TabChanged' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-TabChanged' class='name expandable'>TabChanged</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>wrapper around OnInitAndTabChange which also unhides all fields on the form ...</div><div class='long'><p>wrapper around OnInitAndTabChange which also unhides all fields on the form</p>\n</div></div></div><div id='method-addTemplateStatesToStates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-addTemplateStatesToStates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-addTemplateStatesToStates' class='name expandable'>addTemplateStatesToStates</a>( <span class='pre'>templateStates</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>adds states to the statemanager ...</div><div class='long'><p>adds states to the statemanager</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>templateStates</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-applyTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-applyTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-applyTemplate' class='name expandable'>applyTemplate</a>( <span class='pre'>templateObject</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>renders a template using the passed config and adds it to the statemanager ...</div><div class='long'><p>renders a template using the passed config and adds it to the statemanager</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>templateObject</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-assignPropToFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-assignPropToFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-assignPropToFields' class='name expandable'>assignPropToFields</a>( <span class='pre'>state, propname</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>assigns props defined in a state object to the respective fields ...</div><div class='long'><p>assigns props defined in a state object to the respective fields</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>state</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>propname</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-assignResponders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-assignResponders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-assignResponders' class='name expandable'>assignResponders</a>( <span class='pre'>state</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>assings responders of a state to the respective field ...</div><div class='long'><p>assings responders of a state to the respective field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>state</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-assignValidationFunctionsToWindow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-assignValidationFunctionsToWindow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-assignValidationFunctionsToWindow' class='name expandable'>assignValidationFunctionsToWindow</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>assigns the validator function to the window object, just like ELO WF does it. ...</div><div class='long'><p>assigns the validator function to the window object, just like ELO WF does it.</p>\n</div></div></div><div id='method-assignValidators' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-assignValidators' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-assignValidators' class='name expandable'>assignValidators</a>( <span class='pre'>state</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>assigns validators of a state to the respective field ...</div><div class='long'><p>assigns validators of a state to the respective field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>state</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-batchProcessProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-batchProcessProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-batchProcessProperties' class='name expandable'>batchProcessProperties</a>( <span class='pre'>batchProperties</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>iterates over the batchProperties defined in a state and performs the batch-tasks accordingly ...</div><div class='long'><p>iterates over the batchProperties defined in a state and performs the batch-tasks accordingly</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>batchProperties</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-calculateDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-calculateDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-calculateDate' class='name expandable'>calculateDate</a>( <span class='pre'>isoDate, durationNumber, durationUnit, terminationPoint</span> ) : Integer<span class=\"signature\"></span></div><div class='description'><div class='short'>calculates a date in the future using input parameters ...</div><div class='long'><p>calculates a date in the future using input parameters</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isoDate</span> : Integer <div class='sub-desc'><p>isoDate as starting point</p>\n</div></li><li><span class='pre'>durationNumber</span> : Integer <div class='sub-desc'><p>number representing e.g. weeks, days (any momentJS unit)</p>\n</div></li><li><span class='pre'>durationUnit</span> : String<div class='sub-desc'><p>momentJS unit descriptor (y, Q, M, w, d)</p>\n</div></li><li><span class='pre'>terminationPoint</span> : String<div class='sub-desc'><p>momentJS unit descriptor (y, Q, M, w, d)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Integer</span><div class='sub-desc'><p>the new date as an isoDate</p>\n</div></li></ul></div></div></div><div id='method-determineUndefinedFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-determineUndefinedFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-determineUndefinedFields' class='name expandable'>determineUndefinedFields</a>( <span class='pre'>params</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-endsWith' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-endsWith' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-endsWith' class='name expandable'>endsWith</a>( <span class='pre'>str, needle</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>returns true if the passed string str ends with passed string needle, otherwise false ...</div><div class='long'><p>returns true if the passed string <code>str</code> ends with passed string <code>needle</code>, otherwise false</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>needle</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-executeOnSaveRules' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-executeOnSaveRules' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-executeOnSaveRules' class='name expandable'>executeOnSaveRules</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>executes OnSaveRules and consolidates their results ...</div><div class='long'><p>executes OnSaveRules and consolidates their results</p>\n</div></div></div><div id='method-getActiveTabId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-getActiveTabId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-getActiveTabId' class='name expandable'>getActiveTabId</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>determines the active tab's id e.g. ...</div><div class='long'><p>determines the active tab's id e.g. \"_510_time_details\" and returns it</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getElementsOfAllTabsOnForm' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-getElementsOfAllTabsOnForm' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-getElementsOfAllTabsOnForm' class='name expandable'>getElementsOfAllTabsOnForm</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>determines all tab Elements ...</div><div class='long'><p>determines all tab Elements</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>[{} (HTML-div)]</p>\n</div></li></ul></div></div></div><div id='method-getNameOfKwlSource' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-getNameOfKwlSource' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-getNameOfKwlSource' class='name expandable'>getNameOfKwlSource</a>( <span class='pre'>source</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getNamesOfAllFieldsOnForm' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-getNamesOfAllFieldsOnForm' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-getNamesOfAllFieldsOnForm' class='name expandable'>getNamesOfAllFieldsOnForm</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>collects all fields that may be used in the form ...</div><div class='long'><p>collects all fields that may be used in the form</p>\n</div></div></div><div id='method-getNewFieldsOnForm' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-getNewFieldsOnForm' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-getNewFieldsOnForm' class='name expandable'>getNewFieldsOnForm</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>collects all fields that were added to the form since initialize ...</div><div class='long'><p>collects all fields that were added to the form since initialize</p>\n</div></div></div><div id='method-getPartsOfTab' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-getPartsOfTab' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-getPartsOfTab' class='name expandable'>getPartsOfTab</a>( <span class='pre'>tab</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>determines all template/part elements inside tabs ...</div><div class='long'><p>determines all template/part elements inside tabs</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tab</span> : Object<div class='sub-desc'></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>[{} (HTML-div)]</p>\n</div></li></ul></div></div></div><div id='method-getShortName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-getShortName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-getShortName' class='name expandable'>getShortName</a>( <span class='pre'>fieldName, prefix</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>determines a short name of a field using the prefix e.g. ...</div><div class='long'><p>determines a short name of a field using the prefix e.g. HR_PERSONNEL.</p>\n\n<p>IX_MAP_HR_PERSONNEL_DEPARTMENT -> department</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>e.g. IX_MAP_HR_PERSONNEL_DEPARTMENT</p>\n</div></li><li><span class='pre'>prefix</span> : String<div class='sub-desc'><p>e.g. HR_PERSONNEL</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hidePartsContainingOnlyEmptyFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-hidePartsContainingOnlyEmptyFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-hidePartsContainingOnlyEmptyFields' class='name expandable'>hidePartsContainingOnlyEmptyFields</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>hides all parts of a tab which where none of each part's fields has a value. ...</div><div class='long'><p>hides all parts of a tab which where none of each part's fields has a value.</p>\n</div></div></div><div id='method-hideUnnecessaryParts' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-hideUnnecessaryParts' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-hideUnnecessaryParts' class='name expandable'>hideUnnecessaryParts</a>( <span class='pre'>necessaryFields</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>hides all parts which do not contain any of the fields listed in the passed array ...</div><div class='long'><p>hides all parts which do not contain any of the fields listed in the passed array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>necessaryFields</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-initialize' class='name expandable'>initialize</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>initializes the class. ...</div><div class='long'><p>initializes the class.</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-initializeFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-initializeFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-initializeFields' class='name expandable'>initializeFields</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>builds the \"fields\" object, which is accessible via me.fields\nusing the FormWrapper.Field Class ...</div><div class='long'><p>builds the \"fields\" object, which is accessible via me.fields\nusing the FormWrapper.Field Class</p>\n</div></div></div><div id='method-initializeNewField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-initializeNewField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-initializeNewField' class='name expandable'>initializeNewField</a>( <span class='pre'>name</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>adds a new field to the \"fields\" object, which is accessible via me.fields\nusing the FormWrapper.Field Class ...</div><div class='long'><p>adds a new field to the \"fields\" object, which is accessible via me.fields\nusing the FormWrapper.Field Class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initializeNewFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-initializeNewFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-initializeNewFields' class='name expandable'>initializeNewFields</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>adds new fields (which were added to the form since initialize) to the \"fields\" object, which is accessible via me.fi...</div><div class='long'><p>adds new fields (which were added to the form since initialize) to the \"fields\" object, which is accessible via me.fields\nusing the FormWrapper.Field Class</p>\n</div></div></div><div id='method-initializeRowFieldsOfMapTableKwl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-initializeRowFieldsOfMapTableKwl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-initializeRowFieldsOfMapTableKwl' class='name expandable'>initializeRowFieldsOfMapTableKwl</a>( <span class='pre'>kwlFields</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>kwlFields</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initializeTabs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-initializeTabs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-initializeTabs' class='name expandable'>initializeTabs</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>builds the \"tabs\" object, which is accessible via me.tabs\nusing the FormWrapper.Tab Class ...</div><div class='long'><p>builds the \"tabs\" object, which is accessible via me.tabs\nusing the FormWrapper.Tab Class</p>\n</div></div></div><div id='method-logFieldValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-logFieldValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-logFieldValues' class='name expandable'>logFieldValues</a>( <span class='pre'>nolog</span> ) : [{fieldName: String, fieldValue: String}] || undefined<span class=\"signature\"></span></div><div class='description'><div class='short'>logs all fieldnames and their values to the console (as a table if implemented in the JS-Engine). ...</div><div class='long'><p>logs all fieldnames and their values to the console (as a table if implemented in the JS-Engine).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>nolog</span> : Boolean<div class='sub-desc'><p>returns fields and their values as an array instead of doing a console-log</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>[{fieldName: String, fieldValue: String}] || undefined</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-processAFieldsProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-processAFieldsProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-processAFieldsProperties' class='name expandable'>processAFieldsProperties</a>( <span class='pre'>fieldName, aFieldsProperties, noLog</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>used in setFieldProperties to map the defined properties to functions ...</div><div class='long'><p>used in setFieldProperties to map the defined properties to functions</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>aFieldsProperties</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>noLog</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processAPartsProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-processAPartsProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-processAPartsProperties' class='name expandable'>processAPartsProperties</a>( <span class='pre'>partId, tabId, aPartsProperties</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>used in setTabProperties to map the defined properties to functions ...</div><div class='long'><p>used in setTabProperties to map the defined properties to functions</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>partId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>tabId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>aPartsProperties</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-propIsField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-propIsField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-propIsField' class='name expandable'>propIsField</a>( <span class='pre'>prop</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>determines if the passed string is a field which can be handled by the FormWrapper. ...</div><div class='long'><p>determines if the passed string is a field which can be handled by the FormWrapper.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>prop</span> : Object<div class='sub-desc'></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-reassignEloVerify' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-reassignEloVerify' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-reassignEloVerify' class='name expandable'>reassignEloVerify</a>( <span class='pre'>element, newJsVal</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>used by assignValidationFunctionToWindow ...</div><div class='long'><p>used by assignValidationFunctionToWindow</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>newJsVal</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-reassignLocalizedKwlValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-reassignLocalizedKwlValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-reassignLocalizedKwlValues' class='name expandable'>reassignLocalizedKwlValues</a>( <span class='pre'>opts</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>sets localizedKwl keys again (e.g. ...</div><div class='long'><p>sets localizedKwl keys again (e.g. to receive translated text)\nthis is usually run once during initialization, but can be called manually at any time</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opts</span> : force: Boolean<div class='sub-desc'><p>if defined, forces a reassignment of all localizedKwl values.\n                             Usually, only incomplete localizedKwl values are reassigned</p>\n</div></li></ul></div></div></div><div id='method-removeBodyClasses' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-removeBodyClasses' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-removeBodyClasses' class='name expandable'>removeBodyClasses</a>( <span class='pre'>bodyClasses</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>removes bodyclasses ...</div><div class='long'><p>removes bodyclasses</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bodyClasses</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-removeFromUndefinedFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-removeFromUndefinedFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-removeFromUndefinedFields' class='name expandable'>removeFromUndefinedFields</a>( <span class='pre'>name</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-removeOldBodyClasses' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-removeOldBodyClasses' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-removeOldBodyClasses' class='name expandable'>removeOldBodyClasses</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>removes all bodyClasses which were set by the previous state ...</div><div class='long'><p>removes all bodyClasses which were set by the previous state</p>\n</div></div></div><div id='method-returnCalculatedDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-returnCalculatedDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-returnCalculatedDate' class='name expandable'>returnCalculatedDate</a>( <span class='pre'>srcDateFieldName, durationFieldName, terminationPointFieldName, dstDateFieldName, offsetNumber, offsetUnit</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>see setCalculatedDate ...</div><div class='long'><p>see setCalculatedDate</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcDateFieldName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>durationFieldName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>terminationPointFieldName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>dstDateFieldName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>offsetNumber</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>offsetUnit</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setBodyClasses' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-setBodyClasses' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-setBodyClasses' class='name expandable'>setBodyClasses</a>( <span class='pre'>bodyClasses</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bodyClasses</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setCalculatedDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-setCalculatedDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-setCalculatedDate' class='name expandable'>setCalculatedDate</a>( <span class='pre'>srcDateFieldName, durationFieldName, terminationPointFieldName, dstDateFieldName, offsetNumber, offsetUnit, onlyReturn</span> ) : undefined || Integer (isoDate)<span class=\"signature\"></span></div><div class='description'><div class='short'>uses calculateDate internally to simplify setting the value to a target field ...</div><div class='long'><p>uses calculateDate internally to simplify setting the value to a target field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcDateFieldName</span> : String<div class='sub-desc'><p>start date field name or isoDate</p>\n</div></li><li><span class='pre'>durationFieldName</span> : String<div class='sub-desc'><p>field name of a field which holds a durationNumber</p>\n</div></li><li><span class='pre'>terminationPointFieldName</span> : String<div class='sub-desc'><p>field name of a field which holds a termination point (at the end of the month, year, quarter,...)</p>\n</div></li><li><span class='pre'>dstDateFieldName</span> : String<div class='sub-desc'><p>this field will receive the return value of calculateDate</p>\n</div></li><li><span class='pre'>offsetNumber</span> : String<div class='sub-desc'><p>adjusts the calculated date by value (+-x)</p>\n</div></li><li><span class='pre'>offsetUnit</span> : String<div class='sub-desc'><p>unit for adjustment</p>\n</div></li><li><span class='pre'>onlyReturn</span> : Boolean<div class='sub-desc'><p>if true, returns the calculated value instead of setting the value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>undefined || Integer (isoDate)</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setFieldProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-setFieldProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-setFieldProperties' class='name expandable'>setFieldProperties</a>( <span class='pre'>fieldProperties</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>iterates over the fieldProperties defined in a state and assigns these properties\nto the respective field ...</div><div class='long'><p>iterates over the fieldProperties defined in a state and assigns these properties\nto the respective field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldProperties</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setNewBodyClasses' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-setNewBodyClasses' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-setNewBodyClasses' class='name expandable'>setNewBodyClasses</a>( <span class='pre'>bodyClasses</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bodyClasses</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setState' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-setState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-setState' class='name expandable'>setState</a>( <span class='pre'>stateName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>sets a state from the \"states\"-object by name ...</div><div class='long'><p>sets a state from the \"states\"-object by name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>stateName</span> : String<div class='sub-desc'><p>name of the state as defined in the \"states\"-object</p>\n</div></li></ul></div></div></div><div id='method-setTabProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-setTabProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-setTabProperties' class='name expandable'>setTabProperties</a>( <span class='pre'>tabProperties</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>iterates over the tabProperties defined in a state and assigns these properties\nto the respective tab. ...</div><div class='long'><p>iterates over the tabProperties defined in a state and assigns these properties\nto the respective tab. However, you should not try to assign properties to tabs\nbut to parts. (tab names can change too easily which winds up to orphaned rules)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tabProperties</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-shouldISave' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-shouldISave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-shouldISave' class='name expandable'>shouldISave</a>( <span class='pre'>rule</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Only returns false if the rule matches and saveValues is false. ...</div><div class='long'><p>Only returns false if the rule matches and saveValues is false.\nAlso executes \"registerUpdate\", if defined.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rule</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-today' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-today' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-today' class='name expandable'>today</a>( <span class='pre'></span> ) : Integer (isodate)<span class=\"signature\"></span></div><div class='description'><div class='short'>determines the current day as isoDate using the beginning of the day as time and returns it ...</div><div class='long'><p>determines the current day as isoDate using the beginning of the day as time and returns it</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Integer (isodate)</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-wfMeetsVersionRequirement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper'>sol.common.forms.FormWrapper</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-method-wfMeetsVersionRequirement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper-method-wfMeetsVersionRequirement' class='name expandable'>wfMeetsVersionRequirement</a>( <span class='pre'>requiredVersion</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>returns true if the running WF's version is >= the passed requiredVersion\nrequiredVersion (String)\n e.g. ...</div><div class='long'><p>returns true if the running WF's version is >= the passed <code>requiredVersion</code>\nrequiredVersion (String)\n e.g. \"10.02.000\"</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>requiredVersion</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{"elowf":true,"abstract":true}});